<?php


/**
 * Widget liste de CPT
 *
 * @since 2.8.0
 */

add_action( 'widgets_init', 'register_CPTlist_widget' ); // function to load my widget
 
// function to register my widget
function register_CPTlist_widget() {
	register_widget( 'WP_Widget_CPTlist' );
} 

class WP_Widget_CPTlist extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_CPTlist', 'description' => __('Liste des items d\'un CPT'));
		/*$control_ops = array('width' => 400, 'height' => 350);*/
		parent::__construct('CPTlist', __('CPT liste'), $widget_ops/*, $control_ops*/);
	}

	public function widget( $args, $instance ) {

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		/**
		 * Filter the content of the Text widget.
		 *
		 * @since 2.3.0
		 *
		 * @param string    $widget_text The widget content.
		 * @param WP_Widget $instance    WP_Widget instance.
		 */
		$text = apply_filters( 'widget_CPTlist', empty( $instance['text'] ) ? '' : $instance['text'], $instance );
		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
			<div class="widget_recette">
				<?php 
				$image_found = 0;
				$post_type = $instance['post_type'];
				$post_type_object = get_post_type_object( $post_type );
				//var_dump($post_type_object);
				$args = array(
					'post_type' 		=> $post_type,
					'order_by'			=> 'date',
					'order'				=> 'DESC',
					'posts_per_page' 	=> -1
					);
				// The Query
				$the_query = new WP_Query( $args );
				//var_dump($the_query->query_vars);
				// The Loop
				global $post; 
				if ( $the_query->have_posts() ) : ?>

					<form method="get" action="<?php echo get_home_url();?>">
						<select id="widget-<?php echo $post_type; ?>-list" class="postform" name="<?php echo $post_type; ?>">
							
					
					<?php 
						while ( $the_query->have_posts() ) :
						$the_query->the_post();

					?>
							<option class="level-0" value="<?php echo $post->post_name; ?>"><?php the_title();?></option>

					<?php
						endwhile;
					?>
						</select>
						<input type="submit" value="go »">
					</form>
					
				<?php endif;
				/* Restore original Post Data */
				wp_reset_postdata();
				?>
			</div>
		<?php
		echo $args['after_widget'];
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['post_type'] = $new_instance['post_type'];
		return $instance;
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'post_type' => '' ) );
		$title = strip_tags($instance['title']);
		$post_type = $instance['post_type'];
		$args = array(
		   'public'   => true,
		   /*'_builtin' => true*/
		);
		$post_types = get_post_types( $args, 'names', 'and' );
?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

		<select name="<?php echo $this->get_field_name('post_type'); ?>" id="<?php echo $this->get_field_id('post_type'); ?>">
			<?php foreach ( $post_types as $pt ) : ?>
				<option <?php if ( $post_type == $pt ) echo "selected"; ?>><?php echo $pt; ?></option>
			<?php endforeach; ?>
		</select>

<?php
	}
}