<?php


/**
 * Text widget class + image
 *
 * @since 2.8.0
 */

add_action( 'widgets_init', 'register_cpt_widget' ); // function to load my widget
 
// function to register my widget
function register_cpt_widget() {
	register_widget( 'WP_Widget_Text_CPT' );
} 

class WP_Widget_Text_CPT extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_CPT', 'description' => __('Accès aux CPT'));
		/*$control_ops = array('width' => 400, 'height' => 350);*/
		parent::__construct('CPT', __('CPT'), $widget_ops/*, $control_ops*/);
	}

	public function widget( $args, $instance ) {

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		/**
		 * Filter the content of the Text widget.
		 *
		 * @since 2.3.0
		 *
		 * @param string    $widget_text The widget content.
		 * @param WP_Widget $instance    WP_Widget instance.
		 */
		$text = apply_filters( 'widget_CPT', empty( $instance['text'] ) ? '' : $instance['text'], $instance );
		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
			<div class="textwidget">
				<?php 
				$image_found = 0;
				$post_type_object = get_post_type_object( $instance['post_type'] );
				//var_dump($post_type_object);
				$args = array(
					'post_type' 		=> $instance['post_type'],
					'order_by'			=> 'date',
					'order'				=> 'DESC',
					'posts_per_page' 	=> 10
					);
				// The Query
				$the_query = new WP_Query( $args );
				//var_dump($the_query->query_vars);
				// The Loop
				if ( $the_query->have_posts() ) :
					while ( $the_query->have_posts() ) :
						$the_query->the_post();

						if ( $thumbnail_id = get_post_thumbnail_id( get_the_id() ) ) :
							$image = wp_get_attachment_image( $thumbnail_id, 'sela-grid-thumbnail' );?>
							<a href="<?php echo site_url( '/'.$post_type_object->rewrite['slug']); ?>">
								<?php echo $image; ?>
							</a>
							<?php
							$image_found = 1;
							break;
						endif;
					endwhile;
					if ( !$image_found ) :
						$post_type_object = get_post_type_object( $instance['post_type'] )?>
						<a href="<?php echo site_url( '/'.$post_type_object->rewrite['slug']); ?>">
							<?php echo '>> '.$post_type_object->labels->all_items.'<br />'; ?>
						</a>
					<?php endif; ?>
				<?php else : ?>
					<a href="<?php echo site_url( '/'.$post_type_object->rewrite['slug']); ?>">
						<?php echo '>> '.$post_type_object->labels->all_items.'<br />'; ?>
					</a>
				<?php endif;
				/* Restore original Post Data */
				wp_reset_postdata();
				?>
				<?php echo !empty( $instance['filter'] ) ? wpautop( $text ) : $text; ?>
			</div>
		<?php
		echo $args['after_widget'];
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		if ( current_user_can('unfiltered_html') )
			$instance['text'] =  $new_instance['text'];
		else
			$instance['text'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text']) ) ); // wp_filter_post_kses() expects slashed
		$instance['filter'] = ! empty( $new_instance['filter'] );
		$instance['post_type'] = $new_instance['post_type'];
		return $instance;
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'text' => '', 'post_type' => '' ) );
		$title = strip_tags($instance['title']);
		$text = esc_textarea($instance['text']);
		$post_type = $instance['post_type'];
		$args = array(
		   'public'   => true,
		   /*'_builtin' => true*/
		);
		$post_types = get_post_types( $args, 'names', 'and' );
?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

		<textarea class="widefat" rows="16" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo $text; ?></textarea>

		<p><input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox" <?php checked(isset($instance['filter']) ? $instance['filter'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>"><?php _e('Automatically add paragraphs'); ?></label></p>
		<select name="<?php echo $this->get_field_name('post_type'); ?>" id="<?php echo $this->get_field_id('post_type'); ?>">
			<?php foreach ( $post_types as $pt ) : ?>
				<option <?php if ( $post_type == $pt ) echo "selected"; ?>><?php echo $pt; ?></option>
			<?php endforeach; ?>
		</select>

<?php
	}
}